<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="py-6">
        <div class="max-w-8xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h2 class="font-semibold text-xl text-gray-800 leading-tight mb-8 border-b-2 border-slate-100 pb-4">
                        <?php echo e(__('Dashboard')); ?>

                    </h2>
                    <div class="grid grid-cols-2 md:grid-cols-2 lg:grid-cols-4 gap-4 mt-6 mb-6">
                        <div class="border border-gray-200 p-4 rounded flex flex-col items-center justify-center">
                            <p class="text-2xl mt-2 font-bold"><?php echo e(config('app.currency') . $totalBills); ?></p>
                            <h2 class="text-l"><?php echo e(__('Total Bills')); ?></h2>
                        </div>
                        <div class="border border-gray-200 p-4 rounded flex flex-col items-center justify-center">
                            <p class="text-2xl mt-2 font-bold"><?php echo e(config('app.currency') . $totalPayments); ?></p>
                            <h2 class="text-l"><?php echo e(__('Total Payments')); ?></h2>
                        </div>
                        <div class="border border-gray-200 p-4 rounded flex flex-col items-center justify-center">
                            <p class="text-2xl mt-2 font-bold"><?php echo e(config('app.currency') . $billsThisMonth); ?></p>
                            <h2 class="text-l"><?php echo e(__('Bills This Month')); ?></h2>
                        </div>
                        <div class="border border-gray-200 p-4 rounded flex flex-col items-center justify-center">
                            <p class="text-2xl mt-2 font-bold"><?php echo e(config('app.currency') . $paymentsThisMonth); ?></p>
                            <h2 class="text-l"><?php echo e(__('Payments This Month')); ?></h2>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <h3 class="mt-6 mb-6 font-semibold"><?php echo e(__('Billing and payment per month')); ?></h3>
                            <canvas id="monthlyChart"></canvas>
                        </div>
                        <div>
                            <h3 class="mt-6 mb-6 font-semibold"><?php echo e(__('Billing and payment per day')); ?></h3>
                            <canvas id="dailyChart"></canvas>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4 mt-6">
                        <div class="border-l-2 bg-neutral-50 border-neutral-500 p-4">
                            <h2 class="text-l font-bold"><?php echo e(__('Total Users')); ?></h2>
                            <p class="text-xl mt-2 font-bold"><?php echo e($totalUsers); ?></p>
                        </div>
                        <div class="border-l-2 bg-neutral-50 border-neutral-500 p-4">
                            <h2 class="text-l font-bold"><?php echo e(__('Users With Due')); ?></h2>
                            <p class="text-xl mt-2 font-bold"><?php echo e($usersWithDueCount); ?></p>
                        </div>
                        <div class="border-l-2 bg-neutral-50 border-neutral-500 p-4">
                            <h2 class="text-l font-bold"><?php echo e(__('Bills This Year')); ?></h2>
                            <p class="text-xl mt-2 font-bold"><?php echo e(config('app.currency') . $billsThisYear); ?></p>
                        </div>
                        <div class="border-l-2 bg-neutral-50 border-neutral-500 p-4">
                            <h2 class="text-l font-bold"><?php echo e(__('Payments This Year')); ?></h2>
                            <p class="text-xl mt-2 font-bold"><?php echo e(config('app.currency') . $paymentsThisYear); ?></p>
                        </div>
                    </div>

                    <div class="mt-8">
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <h3 class="font-semibold"><?php echo e(__('Recent Users')); ?></h3>
                                <table class="table-auto border-collapse border-b border-slate-400 mt-4 w-full">
                                    <thead>
                                    <tr>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Name')); ?></th>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Package')); ?></th>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Joined')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $recentUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="border-b border-slate-300 p-2"><?php echo e($user->name); ?></td>
                                            <td class="border-b border-slate-300 p-2"><?php echo e($user->detail->package_name); ?></td>
                                            <td class="border-b border-slate-300 p-2"><?php echo e(date('Y-m-d', strtotime($user->created_at))); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <div>
                                <h3 class="font-semibold"><?php echo e(__('Recent Payments')); ?></h3>
                                <table class="table-auto border-collapse border-b border-slate-400 mt-4 w-full">
                                    <thead>
                                    <tr>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('User')); ?></th>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Amount')); ?></th>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Date')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $recentPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="border-b border-slate-300 p-2"><?php echo e($payment->user->name); ?></td>
                                            <td class="border-b border-slate-300 p-2"><?php echo e(config('app.currency') . $payment->package_price); ?></td>
                                            <td class="border-b border-slate-300 p-2"><?php echo e(date('Y-m-d', strtotime($payment->created_at))); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="mt-8">
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <h3 class="font-semibold"><?php echo e(__('Users With Due')); ?></h3>
                                <table class="table-auto border-collapse border-b border-slate-400 mt-4 w-full">
                                    <thead>
                                    <tr>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Name')); ?></th>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Package')); ?></th>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Due')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $usersWithDueList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="border-b border-slate-300 p-2"><?php echo e($user->name); ?></td>
                                            <td class="border-b border-slate-300 p-2"><?php echo e($user->detail->package_name); ?></td>
                                            <td class="border-b border-slate-300 p-2"><?php echo e(config('app.currency') . $user->due_amount($user->id)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <div>
                                <h3 class="font-semibold"><?php echo e(__('Recent Tickets')); ?></h3>
                                <table class="table-auto border-collapse border-b border-slate-400 mt-4 w-full">
                                    <thead>
                                    <tr>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Subject')); ?></th>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Status')); ?></th>
                                        <th class="border-b border-slate-300 p-2 text-left bg-slate-50"><?php echo e(__('Date')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $recentTickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="border-b border-slate-300 p-2"><?php echo e($ticket->subject); ?></td>
                                            <td class="border-b border-slate-300 p-2"><?php echo e($ticket->status); ?></td>
                                            <td class="border-b border-slate-300 p-2"><?php echo e(date('Y-m-d', strtotime($ticket->created_at))); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            const billingData = <?php echo json_encode($billingData, 15, 512) ?>;
            const paymentData = <?php echo json_encode($paymentData, 15, 512) ?>;
            const labels = Array.from({ length: billingData.length }, (_, i) => (i + 1).toString());

            const monthlyCtx = document.getElementById('monthlyChart').getContext('2d');
            new Chart(monthlyCtx, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [
                        {
                            label: 'Monthly Billing Amount',
                            data: billingData,
                            backgroundColor: 'rgba(54, 162, 235, 0.5)',
                            borderColor: 'rgba(54, 162, 235, 1)',
                            borderWidth: 1
                        },
                        {
                            label: 'Monthly Payment Amount',
                            data: paymentData,
                            backgroundColor: 'rgba(75, 192, 192, 0.5)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

            const dailyBillingData = <?php echo json_encode($dailyBillingData, 15, 512) ?>;
            const dailyPaymentData = <?php echo json_encode($dailyPaymentData, 15, 512) ?>;
            const dailyLabels = Array.from({ length: dailyBillingData.length }, (_, i) => (i + 1).toString());

            const dailyCtx = document.getElementById('dailyChart').getContext('2d');
            new Chart(dailyCtx, {
                type: 'bar',
                data: {
                    labels: dailyLabels,
                    datasets: [
                        {
                            label: 'Daily Billing Amount',
                            data: dailyBillingData,
                            backgroundColor: 'rgba(54, 162, 235, 0.5)',
                            borderColor: 'rgba(54, 162, 235, 1)',
                            borderWidth: 1
                        },
                        {
                            label: 'Daily Payment Amount',
                            data: dailyPaymentData,
                            backgroundColor: 'rgba(75, 192, 192, 0.5)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<?php /**PATH /Users/ahsan/Documents/Personal/Projects/betternet4.1/resources/views/dashboard.blade.php ENDPATH**/ ?>