<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name')); ?></title>
    <style>
        body {
            font-family: 'Roboto', Helvetica, Arial, sans-serif;
            color: #4d5155;
            font-size: 14px;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        td, th {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
        }
        .header {
            height: 50px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid #4f46e5;
        }
        .header h1 {
            font-size: 44px;
            color: #333332;
        }
        .section {
            width: 100%;
            margin-top: 50px;
        }
        .section.no-margin {
            margin-top: 10px;
            margin-bottom: 20px;
        }
        .label {
            white-space: nowrap;
            color: #8c8d8e;
            margin-top: 30px;
        }
    </style>
</head>
<body>
<div class="header">
    <h1><?php echo e(__('Payment history')); ?></h1>
</div>

<div class="section no-margin">
    <span class="label"><?php echo e(__('Report generated by ') . config('app.name') . __(' ') . date('Y-m-d h:i A')); ?></span>
</div>

<table>
    <thead>
    <tr>
        <th><?php echo e(__('Invoice')); ?></th>
        <th><?php echo e(__('User')); ?></th>
        <th><?php echo e(__('Package')); ?></th>
        <th><?php echo e(__('Price')); ?></th>
        <th><?php echo e(__('Method')); ?></th>
        <th><?php echo e(__('Date')); ?></th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($payment->invoice); ?></td>
            <td><?php echo e($payment->user->name); ?></td>
            <td><?php echo e($payment->billing->package_name); ?></td>
            <td><?php echo e(config('app.currency') . $payment->billing->package_price); ?></td>
            <td><?php echo e($payment->payment_method); ?></td>
            <td><?php echo e(date('Y-m-d', strtotime($payment->created_at))); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>
<?php /**PATH /Users/ahsan/Herd/betternet4/resources/views/reports/payment.blade.php ENDPATH**/ ?>